/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.MapElementGraphics;
import xaero.map.element.render.ElementRenderInfo;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.element.render.ElementRenderer;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.icon.XaeroIcon;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportXaeroMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointReader;
import xaero.map.mods.gui.WaypointRenderContext;
import xaero.map.mods.gui.WaypointRenderProvider;
import xaero.map.mods.gui.WaypointSymbolCreator;

public final class WaypointRenderer
extends ElementRenderer<Waypoint, WaypointRenderContext, WaypointRenderer> {
    private final SupportXaeroMinimap minimap;
    private final WaypointSymbolCreator symbolCreator;
    private ElementRenderInfo compatibleRenderInfo;

    private WaypointRenderer(WaypointRenderContext context, WaypointRenderProvider provider, WaypointReader reader, SupportXaeroMinimap minimap, WaypointSymbolCreator symbolCreator) {
        super(context, provider, reader);
        this.minimap = minimap;
        this.symbolCreator = symbolCreator;
    }

    public WaypointSymbolCreator getSymbolCreator() {
        return this.symbolCreator;
    }

    @Override
    public void renderElementShadow(Waypoint w, boolean hovered, float optionalScale, double partialX, double partialY, ElementRenderInfo renderInfo, MapElementGraphics guiGraphics, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider) {
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.translate(partialX, partialY, 0.0);
        matrixStack.scale(optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale, optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale, 1.0f);
        float visibilityAlpha = w.isDisabled() ? 0.3f : 1.0f;
        matrixStack.translate(-14.0f, -41.0f, 0.0f);
        MapRenderHelper.blitIntoExistingBuffer(matrixStack.last().pose(), ((WaypointRenderContext)this.context).regularUIObjectConsumer, 0, 19, 0, 117, 41, 22, 0.0f, 0.0f, 0.0f, renderInfo.brightness * visibilityAlpha / ((WaypointRenderContext)this.context).worldmapWaypointsScale);
    }

    @Override
    public boolean shouldRender(ElementRenderLocation location, boolean shadow) {
        return WorldMap.settings.renderWaypoints && (!shadow || WorldMap.settings.waypointBackgrounds);
    }

    @Override
    public boolean renderElement(Waypoint w, boolean hovered, double optionalDepth, float optionalScale, double partialX, double partialY, ElementRenderInfo renderInfo, MapElementGraphics guiGraphics, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider) {
        int symbolFrameWidth;
        PoseStack matrixStack = guiGraphics.pose();
        boolean renderBackground = hovered || WorldMap.settings.waypointBackgrounds;
        matrixStack.translate(partialX, partialY, 0.0);
        matrixStack.scale(optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale, optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale, 1.0f);
        matrixStack.pushPose();
        float visibilityAlpha = w.isDisabled() ? 0.3f : 1.0f;
        int color = w.getColor();
        String symbol = w.getSymbol();
        int type = w.getType();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (symbol.length() > 1) {
            flagU += 35;
            flagW += 13;
        }
        if (w.isTemporary()) {
            flagU += 83;
        }
        matrixStack.translate((float)(-flagW) / 2.0f, (float)(-flagH + 1), 0.0f);
        if (renderBackground) {
            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.last().pose(), ((WaypointRenderContext)this.context).uniqueTextureUIObjectRenderer, 0.0f, 0.0f, flagU, flagV, flagW, flagH, red * visibilityAlpha, green * visibilityAlpha, blue * visibilityAlpha, visibilityAlpha, textureManager.getTexture(WorldMap.guiTextures).getTexture());
        }
        matrixStack.popPose();
        float oldDestAlpha = w.getDestAlpha();
        if (hovered) {
            w.setDestAlpha(255.0f);
        } else {
            w.setDestAlpha(0.0f);
        }
        if (oldDestAlpha != w.getDestAlpha()) {
            w.setAlphaAnim(new SlowingAnimation(w.getAlpha(), w.getDestAlpha(), 0.8, 1.0));
        }
        if (w.getAlphaAnim() != null) {
            w.setAlpha((float)w.getAlphaAnim().getCurrent());
        }
        float alpha = w.getAlpha();
        XaeroIcon symbolIcon = null;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        Font fontRenderer = Minecraft.getInstance().font;
        int stringWidth = fontRenderer.width(symbol);
        int n = symbolFrameWidth = stringWidth / 2 > 4 ? 62 : 32;
        if (type != 1 && alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolIcon = this.symbolCreator.getSymbolTexture(guiGraphics, symbol);
        } else if (type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolIcon = this.symbolCreator.getDeathSymbolTexture(guiGraphics);
        }
        if (symbolIcon != null) {
            matrixStack.pushPose();
            matrixStack.translate(-1.0f - (float)symbolWidth / 2.0f, (float)(62 + (renderBackground ? -43 + symbolVerticalOffset - 1 : -12)), 0.0f);
            matrixStack.scale(1.0f, -1.0f, 1.0f);
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.last().pose(), ((WaypointRenderContext)this.context).uniqueTextureUIObjectRenderer, 0.0f, 0.0f, symbolIcon.getOffsetX() + 1, symbolIcon.getOffsetY() + 1, symbolFrameWidth, 62, visibilityAlpha, visibilityAlpha, visibilityAlpha, visibilityAlpha, symbolIcon.getTextureAtlas().getWidth(), symbolIcon.getTextureAtlas().getWidth(), symbolIcon.getTextureAtlas().getTextureId());
            matrixStack.popPose();
        }
        if ((int)alpha > 0) {
            int tc = (int)alpha << 24 | 0xFFFFFF;
            String name = w.getName();
            int len = fontRenderer.width(name);
            matrixStack.translate(0.0f, (float)(renderBackground ? -38 : -11), 0.0f);
            matrixStack.scale(3.0f, 3.0f, 1.0f);
            int bgLen = Math.max(len + 2, 10);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), ((WaypointRenderContext)this.context).textBGConsumer, -bgLen / 2, -1, bgLen / 2, 9, red, green, blue, alpha / 255.0f);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.last().pose(), ((WaypointRenderContext)this.context).textBGConsumer, -bgLen / 2, -1, bgLen / 2, 8, 0.0f, 0.0f, 0.0f, alpha / 255.0f * 200.0f / 255.0f);
            if ((int)alpha > 3) {
                matrixStack.translate(0.0f, 0.0f, 1.0f);
                Misc.drawNormalText(matrixStack, name, (float)(-(len - 1)) / 2.0f, 0.0f, tc, false, vanillaBufferSource);
            }
        }
        return false;
    }

    @Override
    public void preRender(ElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, boolean shadow) {
        MultiBufferSource.BufferSource renderTypeBuffers = WorldMap.worldMapClientOnly.customVertexConsumers.getRenderTypeBuffers();
        ((WaypointRenderContext)this.context).regularUIObjectConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.GUI);
        Minecraft.getInstance().getTextureManager().getTexture(WorldMap.guiTextures).setFilter(true, false);
        ((WaypointRenderContext)this.context).textBGConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
        ((WaypointRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_PREMULTIPLIED);
        ((WaypointRenderContext)this.context).deathpoints = this.minimap.getDeathpoints();
        Minecraft mc = Minecraft.getInstance();
        ((WaypointRenderContext)this.context).userScale = mc.screen != null && mc.screen instanceof GuiMap ? ((GuiMap)mc.screen).getUserScale() : 1.0;
    }

    @Override
    public void postRender(ElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, boolean shadow) {
        MultiBufferSource.BufferSource renderTypeBuffers = WorldMap.worldMapClientOnly.customVertexConsumers.getRenderTypeBuffers();
        rendererProvider.draw(((WaypointRenderContext)this.context).uniqueTextureUIObjectRenderer);
        renderTypeBuffers.endBatch();
        Minecraft.getInstance().getTextureManager().getTexture(WorldMap.guiTextures).setFilter(false, false);
    }

    @Override
    public int getOrder() {
        return 200;
    }

    @Override
    public boolean shouldBeDimScaled() {
        return false;
    }

    public static final class Builder {
        private SupportXaeroMinimap minimap;
        private WaypointSymbolCreator symbolCreator;

        private Builder() {
        }

        private Builder setDefault() {
            this.setMinimap(null);
            this.setSymbolCreator(null);
            return this;
        }

        public Builder setMinimap(SupportXaeroMinimap minimap) {
            this.minimap = minimap;
            return this;
        }

        public Builder setSymbolCreator(WaypointSymbolCreator symbolCreator) {
            this.symbolCreator = symbolCreator;
            return this;
        }

        public WaypointRenderer build() {
            if (this.minimap == null || this.symbolCreator == null) {
                throw new IllegalStateException();
            }
            return new WaypointRenderer(new WaypointRenderContext(), new WaypointRenderProvider(this.minimap), new WaypointReader(), this.minimap, this.symbolCreator);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

